﻿//////////////////////////////////////////////
// IntVector.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkMaths
{
	class Vector ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/ByteAlignedClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkMaths
{
	class DLL_MATHS_EXPORT IntVector
	{			
		public :
		
			// Constructor, destructor
			IntVector () noexcept ;
			IntVector (int x, int y) noexcept ;
			IntVector (int x, int y, int z) noexcept ;
			IntVector (int x, int y, int z, int w) noexcept ;
			IntVector (const Vector& other) noexcept ;
			IntVector (const IntVector& other) noexcept ;

			// Getters
			int getX () const ;
			int getY () const ;
			int getZ () const ;
			int getW () const ;

			// Setters
			void setX (int value) ;
			void setY (int value) ;
			void setZ (int value) ;
			void setW (int value) ;

			// Per component operations
			void addX (int value) ;
			void addY (int value) ;
			void addZ (int value) ;
			void addW (int value) ;
			void multX (int value) ;
			void multY (int value) ;
			void multZ (int value) ;
			void multW (int value) ;

			// Length
			float getLengthVec2 () const ;
			float getLengthVec3 () const ;
			float getLengthVec4 () const ;
			float getLengthSquaredVec2 () const ;
			float getLengthSquaredVec3 () const ;
			float getLengthSquaredVec4 () const ;
			// Distance
			float getDistanceVec2 (const IntVector& other) const ;
			float getDistanceVec3 (const IntVector& other) const ;
			float getDistanceVec4 (const IntVector& other) const ;
			float getDistanceSquaredVec2 (const IntVector& other) const ;
			float getDistanceSquaredVec3 (const IntVector& other) const ;
			float getDistanceSquaredVec4 (const IntVector& other) const ;

			// Utilities
			nkMemory::String toString () const ;
			IntVector& fromString (nkMemory::StringView str) ;

			// Operators
			// Egalité
			IntVector& operator= (const IntVector& other) noexcept ;
			IntVector& operator= (const Vector& other) noexcept ;
			// Addition
			IntVector operator+ (const IntVector& other) const ;
			void operator+= (const IntVector& other) ;
			// Soustraction
			IntVector operator- (const IntVector& other) const ;
			void operator-= (const IntVector& other) ;
			// Multiplication
			IntVector operator* (const IntVector& other) const ;
			void operator*= (const IntVector& other) ;
			IntVector operator* (int coeff) const ;
			void operator*= (int coeff) ;
			// Division
			IntVector operator/ (const IntVector& other) const ;
			void operator/= (const IntVector& other) ;
			IntVector operator/ (int coeff) const ;
			void operator/= (int coeff) ;
			// Comparaison
			bool operator== (const IntVector& other) const ;
			bool operator!= (const IntVector& other) const ;
			bool operator< (const IntVector& other) const ;
			bool operator<= (const IntVector& other) const ;
			bool operator> (const IntVector& other) const ;
			bool operator>= (const IntVector& other) const ;

		public :
		
			int _x ;
			int _y ;
			int _z ;
			int _w ;
	} ;
}